package com.nikesu.course.softwareengineering.xml;

import java.io.File;
import java.util.Stack;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class SaxHandler extends DefaultHandler {
	private Stack<String> stack = new Stack<>();
	private double sum = 0.0;
	
	@Override
	public void startElement(String uri, String localName,
			String qName, Attributes attributes) throws SAXException {
		stack.push(qName);
	}
	
	@Override
	public void characters(char[] ch, int start, int length)
			throws SAXException {
		if ("price".equals(stack.peek())) {
			sum += Double.parseDouble(new String(ch, start, length));
		}
	}
	
	@Override
	public void endElement(String uri, String localName,
			String qName) throws SAXException {
		stack.pop();
		if (stack.isEmpty()) {
			System.out.println("SAX Parser: sum = " + sum);
		}
	}
}

public class SaxParser {
	private SAXParserFactory factory = SAXParserFactory.newInstance();
	private SAXParser parser = null;
	private String path;
	
	public SaxParser(String path) {
		this.path = path;
	}
	
	public void parse() {
		try {
			parser = factory.newSAXParser();
			parser.parse(new File(path), new SaxHandler());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
