package com.nikesu.course.softwareengineering.observer;

import java.util.List;
import java.util.ArrayList;

public class Stock {
	private String stockname;
	private int val;
	private List<BrokerInterface> observers = new ArrayList<BrokerInterface>();
	
	public Stock(String stockname) {
		this.stockname = stockname;
		this.val = 0;
		return;
	}

	public void register(BrokerInterface b) {
		observers.add(b);
		return;
	}
	
	public void notifyAllObservers() {
		for (BrokerInterface broker : observers) {
			broker.update(stockname);
		}
		return;
	}
	
	public int getVal() {
		return this.val;
	}
	
	public void setVal(int value) {
		this.val = value;
		notifyAllObservers();
		return;
	}
	
	public String getName() {
		return this.stockname;
	}
}
