package com.nikesu.course.softwareengineering.observer;

import java.util.ArrayList;
import java.util.List;

public class Broker implements BrokerInterface {
	private String brokername;
	private List<Stock> stocks = new ArrayList<Stock>();
	
	public Broker(String brokername) {
		this.brokername = brokername;
		return;
	}
	
	public void newStock(Stock stock) {
		stocks.add(stock);
		stock.register(this);
	}
	
	public String getName() {
		return brokername;
	}
	
	@Override
	public void update(String stockname) {
		System.out.println(brokername + '\t' + stockname);
	}
}
